#include <bits/stdc++.h>

using namespace std;


using ll = long long;

struct hlopok {
    ll t, x;
};


struct line {
    set<pair<ll, ll>> s;

    line () {
        s.insert({0, 0});
    }

    void incr(ll d) {
        set<pair<ll, ll>> v;
        for (auto& [l, r] : s) {
            v.insert({l - d, r + d});
        }
        s = v;
    }

    void upd() {
        if (s.empty()) return;
        auto [fromL, lastR] = *s.begin();
        set<pair<ll, ll>> v;
        auto it = s.begin();
        ++it;
        for (; it != s.end(); ++it) {
            auto [l, r] = *it;
            if (l > r) {
                continue;
            }
            if (l <= lastR) {
                lastR = max(lastR, r);
            } else {
                v.insert({fromL, lastR});
                fromL = l;
                lastR = r;
            }
        }
        v.insert({fromL, lastR});
        s = v;
    }

    void ban(ll lx, ll rx) {
        while (true) {
            auto it = s.lower_bound({lx, -1e10});
            if (it == s.begin()) break;
            --it;
            auto [l, r] = *it;
            if (lx <= r && rx <= r) {
                s.erase(it);
                if (l <= rx - 1) {
                    s.insert({l, rx - 1});
                }
            } else if (r > rx) {
                s.erase(it);
                if (l <= rx - 1) {
                    s.insert({l, rx - 1});
                }
            } else {
                break;
            }
        }

        while (true) {
            auto it = s.lower_bound({lx, -1e10});
            if (it == s.end()) break;
            auto [l, r] = *it;
            if (l <= rx) {
                s.erase(it);
                if (r > rx) {
                    s.insert({rx + 1, r});
                }
            } else {
                break;
            }
        }

        /*set<pair<ll, ll>> v;
        for (auto [l, r] : s) {
            if (lx <= l && r <= rx) {
                continue;
            } else if (lx <= l && l <= rx) {
                v.insert({rx + 1, r});
            } else if (lx <= r && r <= rx) {
                v.insert({l, lx - 1});
            } else if (l <= lx && rx <= r) {
                v.insert({l, lx - 1});
                v.insert({rx + 1, r});
            } else {
                v.insert({l, r});
            }
        }
        s = v;*/
    }
};

bool check(map<ll, vector<ll>>& mp, ll d) {
    if (d == 0) {
        return true;
    }
    --d;
    ll lastT = 0;
    line ln;
    for (const auto& [t, v] : mp) {
        ln.incr(2 * (t - lastT));
        ln.upd();
        lastT = t;
        for (const auto x : v) {
            ln.ban(x - d, x + d);
        }
    }
    ln.upd();
    return ln.s.size();
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<hlopok> v(n);
    for (auto& [t, x] : v) {
        cin >> t >> x;
    }
    map<ll, vector<ll>> mp; // hlopki by time
    for (auto [t, x] : v) {
        mp[t].push_back(x * 2);
    }
    long long left = 0, right = 1e10;
    while (left + 1 < right) {
        long long mid = (left + right) / 2;
        if (check(mp, mid)) {
            left = mid;
        } else {
            right = mid;
        }
    }
    cout << fixed << setprecision(1) << (long double)(left) / 2 << '\n';
    return 0;
}
